#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Blob in a Mirrored RoomMod01.fsh  by    TekF 
//https://www.shadertoy.com/view/tlBGR1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// by Hazel Quantock 2019
// This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. http://creativecommons.org/licenses/by-nc-sa/4.0/


// how deep do the reflections go
const int maxBounces = 15;


// control the tracer precision and efficiency
const float traceStartDistance = .01;
const int traceLoopCount = 200;
const float shadowStartDistance = .1;
const int shadowLoopCount = 50;


// polished copper
//const vec3 blobAlbedo = vec3(0); const vec3 blobSpecColour = vec3(.8,.3,.2); const float blobMaxSpecular = 1.;
// shiny white
const vec3 blobAlbedo = vec3(1); const vec3 blobSpecColour = vec3(.02); const float blobMaxSpecular = 1.;  //.02 = schlick(1.33)
// chocolate
//const vec3 blobAlbedo = vec3(.2,.03,.01); const vec3 blobSpecColour = vec3(.007); const float blobMaxSpecular = .5;



const vec2 quasirand2 = vec2(.754877666247,.569840290998); // from http://extremelearning.com.au/unreasonable-effectiveness-of-quasirandom-sequences/


struct Light
{
    vec3 pos;
    vec3 colour;
};
    
Light lights[] = Light[]
    (
         Light( vec3(1,2,-3), vec3(1)*8. )
        ,Light( vec3(-1,-.5,-1), vec3(1,.1,0)*1. )
        ,Light( vec3(.5,-.9,-.5), vec3(0,.3,1)*.3 )
	);


float Mat1SDF( vec3 p )
{
    // 4 walls
    float f = -abs(p.x-2.5)-(-4.);
    f = min(f, -abs(p.z+1.)-(-5.) );
    
    // 4 more walls at 45 degrees for more interesting reflections!
    f = min(f, -abs((p.z+p.x)*.7071+1.)-(-5.) );
    f = min(f, -abs((p.z-+p.x)*.7071+1.5)-(-4.5) );

    return f;
}


float Mat2SDF( vec3 p )
{
    // blob
    vec3 p1 = p - .7*sin(vec3(1,quasirand2)*iTime);
	vec3 p2 = p - .7*sin(vec3(1,quasirand2)*iTime*quasirand2.x);
	vec3 p3 = p - .7*sin(vec3(1,quasirand2)*iTime*quasirand2.y);
    
    float r = .0;
    float a = length(p )-.8+.4;
    float b = length(p1)-.5+.4;
    float c = length(p2)-.5+.4;
    float d = length(p3)-.5+.4;
    
    // I based this on a smooth-min function, it didn't work as intended but it's pretty!
    float avg = (a+b+c+d)/4.;
    a -= avg;
    b -= avg;
    c -= avg;
    d -= avg;
    return (avg - sqrt( a*a+b*b+c*c+d*d+r*r ))*.8;
}

float Mat3SDF( vec3 p )
{
    // floor
    return -abs(p.y-1.)-(-2.);
}

float SDF( vec3 p )
{
    return min(min(Mat1SDF(p),Mat2SDF(p)),Mat3SDF(p));
}


vec3 Trace( in vec3 p, in vec3 ray )
{
    p += ray*traceStartDistance;
    float epsilon = .001;
    float h = 1.;
    for ( int i=0; i < traceLoopCount; i++ )
    {
        if ( h < epsilon )
            break;
        h = SDF(p);
        p += ray*h;
    }
    return p;
}


float Shadow( in vec3 p, in vec3 toLight )
{
    const float softness = 1.;
    toLight = toLight-p;
    float l = length(toLight);
    vec3 ray = toLight/l;
    float epsilon = .001;
    float t = shadowStartDistance;
    float h = 1.;
    float minh = 1e30;
    for ( int i=0; i < shadowLoopCount; i++ )
    {
        if ( h < epsilon || t > l )
            break;
        h = SDF(p+ray*t);
        minh = min(minh,h/max(t*softness,1.));
        t += h;
    }
    return smoothstep(epsilon,.03,minh);
}


vec3 GetNormal( vec3 p )
{
    vec2 d = vec2(-1,1)*.001;
    return normalize(
            SDF(p+d.xxx)*d.xxx +
            SDF(p+d.yyx)*d.yyx +
            SDF(p+d.yxy)*d.yxy +
            SDF(p+d.xyy)*d.xyy
        );
}


void Shading( out vec3 bounce, out vec3 bounceTint, out vec3 diffuse, in vec3 p, in vec3 ray )
{
    vec3 normal = GetNormal(p);
    
    vec3 light = vec3(0);
    for( int i=0; i < lights.length(); i++ )
    {
        vec3 toLight = lights[i].pos - p;

        float nDotL = dot(normal,toLight);
        if ( nDotL <= 0. ) continue;

        float l = max(nDotL/pow(dot(toLight,toLight),3./2.),0.);

        l *= Shadow(p,lights[i].pos);
        
        light += lights[i].colour * l;
    }
    
    // ambient light
    vec3 ao = vec3(.03,.05,.07);
    // sample SDF to approximate occlusion
    ao *= exp2(min(0.,SDF(p+normal*.3)/.3-1.));
    ao *= exp2(min(0.,SDF(p+normal*.15)/.15-1.));
    ao *= exp2(min(0.,SDF(p+normal*.07)/.07-1.));
    light += ao;
    
    // get material
    vec3 albedo = vec3(.3,.5,.6)*.4;
    vec4 specLevel = vec4(vec3(.9),1);
    
    // put a pattern on the walls, so they're visible
//    albedo *= 1.-.5*pow(texture2D(texture0,vec2(p.y,p.x+p.z)/2.).rgb,vec3(.2));
    specLevel.rgb = vec3(mix( .8, .95, texture2D(texture0,vec2(p.y,p.x+p.z)/2.).g ));
//    normal = normalize( normal + (texture2D(texture0,vec2(p.y,p.x+p.z)/2.).rgb-.5)*.002 );
    
    // frame the mirrors - so we can read the scene better
    float frame = .07;
    if ( abs(p.y-1.) > 2.-frame )//|| abs(p.x-2.5)+abs(p.z+1.) > 9.-frame )
    {
        albedo = vec3(.1);
        specLevel = vec4(0);
    }
    
    float mat1sdf = Mat1SDF(p);
    float mat2sdf = Mat2SDF(p);
    if ( mat2sdf < mat1sdf )
    {
        // main object
        albedo = blobAlbedo;
        specLevel = vec4(blobSpecColour,blobMaxSpecular);
    }
    
    if ( Mat3SDF(p) < min(mat1sdf,mat2sdf) )
    {
        // floor
        vec2 uv = p.xz;
        uv = uv*cos(.3)+sin(.3)*vec2(-1,1)*uv.yx;
        albedo = mix( vec3(.01), vec3(1), step(.0,(fract(uv.x/1.)-.5)*(fract(uv.y/1.)-.5)) );
        float ior = 1.33;
        float schlick = pow((ior-1.)/(ior+1.),2.);
	    specLevel = vec4(vec3(schlick),1);
    	specLevel *= mix( .2, .7, texture2D(texture0,vec2(p.xz)/2.).g );
    	normal = normalize( normal + (texture2D(texture0,vec2(p.xz)/2.).rgb-.5)*.005 );
    }

    float fresnel = pow(dot(normal,ray)+1.,5.);
    
    vec3 spec = mix( specLevel.xyz, specLevel.www, fresnel );
    
    bounceTint = spec;
    diffuse = albedo * (vec3(1)-spec) * light;
    bounce = reflect(ray,normal);
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3 ray = vec3((fragCoord-iResolution.xy*.5)/iResolution.y,2.);
    ray = normalize(ray);
    
    vec3 camPos = vec3(1,0,-4.5) + vec3(1.5,.5,1)*cos(vec3(1,quasirand2).zyx*iTime*.618);
    
    vec3 camK = normalize(vec3(0,-.3,0)-camPos);
    vec3 camI = normalize(cross(vec3(0,1,0),camK));
    vec3 camJ = cross(camK,camI);
    
    ray = ray.x*camI + ray.y*camJ + ray.z*camK;
    
    vec3 pos = camPos;
    vec3 tint = vec3(1);

    fragColor = vec4(0);
    for( int bounce=0; bounce < maxBounces; bounce++ ) // gosh this can handle a lot of bounces!
    {
        pos = Trace( pos, ray );

        vec3 bounceTint, diffuse;
        Shading( ray, bounceTint, diffuse, pos, ray );
        fragColor.rgb += diffuse*tint;
        tint *= bounceTint;
        if ( length(tint) < .01 ) break; // early out if reflections aren't visible
    }
    
    
    fragColor.rgb = pow(fragColor.rgb,vec3(1./2.2));
  //  fragColor = pow(fragColor.rgb,vec3(1./2.2));
    
    fragColor.a = 1.;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

